﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Zestawienie wypłaconych zasiłków i wynagrodzeń</TITLE>
		<script runat="server">
		
    public enum WgParametr {
        WgDatyWypłaty,
        WgOkresuElementu
    }
  
	class Item: IComparable {
		readonly WypElement element;
		readonly bool zaokres;
		readonly string symbol;
		readonly bool wypadek;			
		readonly bool wynagrodzenie;			
		public Item(WypElement element, string symbol, bool wypadek): this(element, symbol, wypadek, false) {
		}
		public Item(WypElement element, string symbol, bool wypadek, bool wynagrodzenie) {
			this.element = element;
			this.zaokres = element is WypElementNieobecność;
			this.symbol = symbol; 
			this.wypadek = wypadek;
			this.wynagrodzenie = wynagrodzenie;
		}
		public WypElement Element {
			get { return element; }
		}
		public int CompareTo(object obj) {
			if (obj==null)
				return 1;
			Item item = obj as Item;
			if (item==null)
				throw new ArgumentException();
			int i = element.Wydzial.Nazwa.CompareTo(item.Element.Wydzial.Nazwa);			
			if (i==0) {
				i = element.Pracownik.CompareTo(item.Element.Pracownik);							
				if (i==0) {
					i = element.Wyplata.Data.CompareTo(item.Element.Wyplata.Data);				
					if (i==0) {
						i = OkresOd.CompareTo(item.OkresOd);
						if (i==0)
							i = Element.ID.CompareTo(item.Element.ID);
					}
				}
			}
			return i;
		}			
		public Date OkresOd {
			get { return zaokres ? element.Okres.From : Date.Empty; }
		}
		public Date OkresDo {
			get { return zaokres ? element.Okres.To : Date.Empty; }
		}
		public int Dni {
			get { return zaokres ? element.Okres.Days : 0; }
		}
		public string Rodzaj {
			get { return symbol + " " + Procent + " " + (wypadek ? "W" : ""); }
		}		
		public string Symbol {
			get { return zaokres ? ((WypElementNieobecność)element).Nieobecność.Zwolnienie.KodChoroby : ""; }
		}
		Percent Procent {
			get { return Element.SkładnikGłówny.Procent; }
		}
		public decimal Podstawa {
			get { return (decimal)Element.SkładnikGłówny.Podstawa1.Value; }
		}
	}
	
	class TPracownik {
		readonly Pracownik pracownik;
		readonly public ArrayList elementy = new ArrayList();
		public TPracownik(Pracownik pracownik) {
			this.pracownik = pracownik;
		}
		public Pracownik Pracownik {
			get { return pracownik; }
		}
	}
	
	class TWydzial {
		readonly Wydzial wydzial;
		readonly public ArrayList pracownicy = new ArrayList();
		public TWydzial(Wydzial wydzial) {
			this.wydzial = wydzial;
		}
		public Wydzial Wydzial {
			get { return wydzial; }
		}
		public ArrayList Pracownicy {
			get { return pracownicy; }
		}
	}
	
	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			Date date = Date.Empty;
			if (context.Contains(typeof(OkresContext)))
				okres = ((OkresContext)context[typeof(OkresContext)]).Okres;
			else
				okres = FromTo.Year(Date.Today.Year);
		}
		
		FromTo okres;
        [Required]
        [Priority(1)]
        public FromTo ZaOkres {
            get { return okres; }
            set {
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        WgParametr wypłatyWgDaty = WgParametr.WgOkresuElementu;
        [Priority(2)]
        [Caption("Wypłaty")]
        public WgParametr WypłatyWgDaty {
            get { return wypłatyWgDaty; }
            set {
                wypłatyWgDaty = value;
                OnChanged(EventArgs.Empty);
            }
        }        
	}
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 
		
	void OnContextLoad(Object sender, EventArgs args) {
        report = ReportHeader;
		Row[] rows = (Row[])dc[typeof(Row[])];
		
		ReportHeader["OKRES"] = pars.ZaOkres.ToString();
        ReportHeader["PARAM"] = CaptionAttribute.EnumToString(pars.WypłatyWgDaty).ToLower();
		
		PlaceModule place = PlaceModule.GetInstance(dc);

		ArrayList elementy = new ArrayList();
        foreach (Pracownik pracownik in rows) {
			SubTable st;
            if (pars.WypłatyWgDaty == WgParametr.WgDatyWypłaty)
                st = place.WypElementy.WgDaty[pracownik];
            else
                st = place.WypElementy.WgPracownik[pracownik];
            st = new SubTable(st, pars.ZaOkres);
			foreach (WypElement e in st) {
                try {
                    Wydzial wdz = e.Wyplata.ListaPlac.Wydzial;
				    KodRSA kr = e.KodRSA;
				    if (kr!=null)
					    switch (kr.Kod) {
                            case 211:
                                elementy.Add(new Item(e, "Pr", false)); break;
                            case 212:
                                elementy.Add(new Item(e, "Wr", false)); break;
                            case 213:
                                elementy.Add(new Item(e, "Pg", false)); break;
                            case 311:
                            case 315:
                            case 325:
                                elementy.Add(new Item(e, "UM", false)); break;
                            case 312:
                            case 316:
                                elementy.Add(new Item(e, "OP", false)); break;
                            case 313:
                            case 317:
                                elementy.Add(new Item(e, "Ch", false)); break;
                            case 314:
                            case 318:
                                elementy.Add(new Item(e, "Ch", true)); break;
                            case 321:
                            case 323:
                                elementy.Add(new Item(e, "Reh", false)); break;
                            case 319:
                            case 322:
                            case 324:
                                elementy.Add(new Item(e, "UR", false)); break;
                            case 327:
                                elementy.Add(new Item(e, "UO", false)); break;
                            case 331:
                            case 332:
                            case 335:
                            case 336:
                                elementy.Add(new Item(e, "WCh", false, true)); break;
                            case 333:
                            case 334:
                            case 337:
                            case 338:
                                elementy.Add(new Item(e, "WCh", true, true)); break;
                        }
                }
                catch { Msg(); }
			}
		}
		elementy.Sort();
		
		ArrayList wydzialy = new ArrayList();
		TWydzial lw = null;
		TPracownik lp = null;
		foreach (Item item in elementy) {
			if (lw==null || lw.Wydzial!=item.Element.Wydzial) {
				lw = new TWydzial(item.Element.Wydzial);
				wydzialy.Add(lw);
				lp = null;
			}
			
			if (lp==null || lp.Pracownik!=item.Element.Pracownik) {
				lp = new TPracownik(item.Element.Pracownik);
				lw.Pracownicy.Add(lp);
			}
			
			lp.elementy.Add(item);
		}
		
		DataRepeater.DataSource = wydzialy;
	}

    void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
		TPracownik tp = (TPracownik)args.Row;
		foreach (Item item in tp.elementy) {
			colOd.AddLine(item.OkresOd);
			colDo.AddLine(item.OkresDo);
			colDni.AddLine(item.Dni);
			colPodstawa.AddLine(item.Podstawa);
			colRodzaj.AddLine(item.Rodzaj);
			colKwota.AddLine(item.Element.Wartosc);			
			
			string symbol = item.Symbol;
			if (symbol=="")
				symbol = "&nbsp;";
			colKod.AddLine(symbol);
			
			string zla = "";
			WypElementNieobecność en = item.Element as WypElementNieobecność;
			if (en!=null)
				zla = en.Nieobecność.Zwolnienie.Numer;
			if (zla=="")
				zla = "&nbsp;";
			colZla.AddLine(zla);
		}
    }
	
	static void Msg(object value) {
	}	
	
    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="Zestawienie wypłaconych zasiłków i wynagrodzeń|</strong>Za okres: <strong>%OKRES%|</strong>Wypłaty: <strong>%PARAM%"></eb:ReportHeader>
			<ea:DataRepeater id="DataRepeater" runat="server" Width="100%">
<P></P>Wydział: 
<ea:DataLabel id="DataLabel1" runat="server" DataMember="Wydzial"></ea:DataLabel><BR>
<ea:Grid id="Grid" runat="server" DataMember="Pracownicy" onbeforerow="Grid_BeforeRow" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
						<ea:GridColumn Align="Left" DataMember="Pracownik" Caption="Pracownik"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" Caption="Okres niezdolności do pracy~od" ID="colOd" NoWrap="True"
							VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" Caption="Okres niezdolności do pracy~do" ID="colDo" NoWrap="True"
							VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="6" Align="Center" Caption="Okres niezdolności do pracy~dni" HideZero="True"
							ID="colDni" NoWrap="True" VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" Caption="Podstawa naliczania" HideZero="True" Format="{0:n}"
							ID="colPodstawa" NoWrap="True" VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="14" Align="Right" Caption="Rodz. i proc. zasiłku" ID="colRodzaj" NoWrap="True" VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" Caption="Kwota" Format="{0:n}" ID="colKwota" NoWrap="True"
							VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" Caption="Nr druku ZLA" ID="colZla" NoWrap="True" VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="8" Align="Center" Caption="Symbol choroby" ID="colKod" NoWrap="True" VAlign="Top"></ea:GridColumn>
					</Columns>
				</ea:Grid></ea:DataRepeater>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
